/* 
 *  LoginRequest.java
 * 
 *  Copyright 2016 Avaya Inc. All Rights Reserved.
 * 
 *  Usage of this source is bound to the terms described
 *  in AvayaLicenseSDK.rtf.
 * 
 *  Avaya - Confidential & Proprietary. Use pursuant to your signed agreement
 *  or Avaya Policy
 * 
 */
package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.javafxrefclient.Logger;

public class LoginRequest extends UserRequest {

    private static final Logger LOG = Logger.getLogger(LoginRequest.class);
    private final String password;
    private final String zone;

    public LoginRequest(String userID, String password, String zone) {
        super(LOG, userID);
        this.password = password;
        this.zone = zone;
    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        getUser().login(password, zone);
        LOG.trace(methodName + "-");
        return null;
    }
}
